﻿using System.Windows.Forms;
using OpcLabs.EasyOpc.DataAccess;
using OpcLabs.EasyOpc.DataAccess.OperationModel;


namespace CSharp_SubscribingToItemsInACSV
{
    public partial class Form1 : Form
    {
        public Form1()
        {
            InitializeComponent();

            //create the OPC Client object
            EasyDAClient easyDAClient1 = new EasyDAClient();

            //assign the callback event to the OPC Client object
            easyDAClient1.ItemChanged += easyDAClient1_ItemChanged;

            //create the file reader
            System.IO.StreamReader file = new System.IO.StreamReader("TestTags.csv");

            //skip the first line since it is a header
            string line = file.ReadLine();

            //keep reading the file until we reach the end.
            while ((line = file.ReadLine()) != null)
            {
                //the file is Comma seperated, we need to break the elements out individually
                string[] splitLine = line.Split(new char[] { ',' });

                //subscribe to each item.
                //splitLine[0] is the Machine IP
                //splitLine[1] is the OPC Server
                //splitLine[2] is the Tag Name
                easyDAClient1.SubscribeItem(splitLine[0], splitLine[1], splitLine[2], 1000, null);
            }


            //Close the file since we are done
            file.Close();
        }
        private void easyDAClient1_ItemChanged(object sender, EasyDAItemChangedEventArgs e)
        {
            //add the item that changed to the list box
            listBox1.Items.Add(string.Format("Tag: {0}, Value: {1}, Quality: {2}, Timestamp: {3}", e.Arguments.ItemDescriptor.ItemId, e.Vtq.Value.ToString(), e.Vtq.Quality.QualityChoiceBitField.ToString(), e.Vtq.Timestamp.ToString()));
        } 
    }
}
